// man benötigt die datei three.min.js

const scene = new THREE.Scene()
const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000)

const renderer = new THREE.WebGLRenderer();
renderer.setSize (window.innerWidth, window.innerHeight);
document.body.appendChild(renderer.domElement );

const geometry = new THREE.BoxGeometry(1,1,1);
const material = new THREE.MeshLambertMaterial({color: 0xffff00});
const cube = new THREE.Mesh(geometry, material);
scene.add(cube);

camera.position.z=5;

const light = new THREE.PointLight( 0xffffff, 20, 100 );
light.position.set( 0, 0, 5 );
scene.add( light );
const loader = new THREE.ObjectLoader();

loader.load(
	// resource URL
	"wuerfel.json",

	// onLoad callback
	// Here the loaded data is assumed to be an object
	function ( obj ) {
		// Add the loaded object to the scene
		scene.add( obj );
	},

	// onProgress callback
	function ( xhr ) {
		console.log( (xhr.loaded / xhr.total * 100) + '% loaded' );
	},

	// onError callback
	function ( err ) {
		console.error( 'An error happened' );
	}
);



const clock = new THREE.Clock(true);
function update()
{
	var delta=clock.getDelta();
	cube.rotation.y+=360*delta*2*Math.PI/360;
}


function animate()
{
	renderer.render(scene,camera);
	update()
	requestAnimationFrame(animate);
}
animate()


function keydown(event)
{
	console.log(event);
}


var oldx=-1;
var oldy=-1;
function mousemove(event)
{
	if (oldx!=-1)
	{
		cube.position.x+=(event.clientX-oldx)*0.015;;
		cube.position.y-=(event.clientY-oldy)*0.015;
	}
	oldx=event.clientX;
	oldy=event.clientY;
	console.log(event);
}



